/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.node;

import com.aptana.core.IMap;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.SudoManager;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodePackageManager;
import com.aptana.js.internal.core.node.Messages;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePackageManager
implements INodePackageManager {
    private static final String VERSION = "version";
    private static final String NPM_ERROR = "ERR!";
    private static final String PREFIX = "prefix";
    private static final String NPM_CONFIG_PREFIX = "NPM_CONFIG_PREFIX";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    private static final String COLOR = "--color";
    private static final String JSON = "--json";
    private static final String SILENT = "-s";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+[\\-a-z0-9]*)");
    private static final String NPM = "npm";
    private static final String INSTALL = "install";
    private static final String LIST = "list";
    private static final String REMOVE = "remove";
    private static final String CONFIG = "config";
    private static final String GET = "get";
    private static final String REBUILD = "rebuild";
    private IPath fConfigPrefixPath;
    private final INodeJS nodeJS;
    private IPath npmPath;

    public NodePackageManager(INodeJS nodeJS) {
        this.nodeJS = nodeJS;
    }

    protected IPath findNPMOnPATH(IPath possible) {
        return ExecutableUtil.find((String)NPM, (boolean)false, (List)CollectionsUtil.newList((Object[])new IPath[]{possible}));
    }

    protected IProcessRunner getProcessRunner() {
        return new ProcessRunner();
    }

    private IPath checkedNPMPath() throws CoreException {
        if (this.exists()) {
            return this.getPath();
        }
        throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", Messages.NodePackageManager_ERR_NPMNotInstalled));
    }

    @Override
    public IStatus install(String packageName, String displayName, boolean global, char[] password, IProgressMonitor monitor) {
        return this.install(packageName, displayName, global, password, null, monitor);
    }

    @Override
    public IStatus install(String packageName, String displayName, boolean global, char[] password, IPath workingDirectory, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        String globalPrefixPath = null;
        try {
            String[] lines;
            String error;
            if (global) {
                globalPrefixPath = this.getGlobalPrefix(global, password, workingDirectory, sub, globalPrefixPath);
            }
            sub.setWorkRemaining(8);
            sub.subTask("Running npm install command");
            IStatus status = this.runNpmInstaller(packageName, displayName, global, password, workingDirectory, INSTALL, (IProgressMonitor)sub.newChild(6));
            if (status.getSeverity() == 8) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (!status.isOK()) {
                String message = status instanceof ProcessStatus ? ((ProcessStatus)status).getStdErr() : status.getMessage();
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Failed to install {0}.\n\n{1}", packageName, message));
                Status status2 = new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedInstallError, packageName));
                return status2;
            }
            if (status instanceof ProcessStatus && !StringUtil.isEmpty((String)(error = ((ProcessStatus)status).getStdErr())) && (lines = error.split("\n")).length > 0 && lines[lines.length - 1].contains(NPM_ERROR)) {
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Failed to install {0}.\n\n{1}", packageName, error));
                Status status3 = new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedInstallError, packageName));
                return status3;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (!StringUtil.isEmpty(globalPrefixPath)) {
                try {
                    sub.subTask("Resetting global NPM prefix");
                    this.setGlobalPrefixPath(password, workingDirectory, (IProgressMonitor)sub.newChild(1), globalPrefixPath);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            sub.done();
        }
    }

    protected String getGlobalPrefix(boolean global, char[] password, IPath workingDirectory, SubMonitor sub, String globalPrefixPath) throws CoreException {
        sub.subTask("Checking global NPM prefix");
        IPath prefixPath = this.getConfigPrefixPath();
        if (prefixPath != null) {
            List args = CollectionsUtil.newList((Object[])new String[]{CONFIG, GET, PREFIX});
            IStatus npmStatus = this.runNpmConfig(args, password, global, workingDirectory, (IProgressMonitor)sub.newChild(1));
            if (npmStatus.isOK()) {
                String prefix = npmStatus.getMessage();
                sub.subTask("Global NPM prefix is " + prefix);
                if (prefix.contains("password:")) {
                    prefix = prefix.substring(prefix.indexOf("password:") + "password:".length());
                }
                if (!prefixPath.toOSString().equals(prefix)) {
                    sub.subTask("Global and user NPM prefix don't match, setting global prefix temporarily to: " + prefixPath.toOSString());
                    globalPrefixPath = prefix;
                    this.setGlobalPrefixPath(password, workingDirectory, (IProgressMonitor)sub.newChild(1), prefixPath.toOSString());
                }
            } else {
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (String)("Failed to get global prefix for NPM: " + npmStatus.getMessage()));
            }
        }
        return globalPrefixPath;
    }

    private IStatus setGlobalPrefixPath(char[] password, IPath workingDirectory, IProgressMonitor monitor, String globalPrefixPath) throws CoreException {
        List args = CollectionsUtil.newList((Object[])new String[]{CONFIG, "set", PREFIX, globalPrefixPath});
        return this.runNpmConfig(args, password, true, workingDirectory, monitor);
    }

    protected IStatus runNpmConfig(List<String> args, char[] password, boolean global, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        List<String> sudoArgs = this.getNpmArguments(global, password);
        sudoArgs.addAll(args);
        return this.getProcessRunner().run(workingDirectory, ShellExecutable.getEnvironment((IPath)workingDirectory), password, sudoArgs, monitor);
    }

    private List<String> proxySettings(Map<String, String> env) {
        IProxyData httpsData;
        IProxyService service = JSCorePlugin.getDefault().getProxyService();
        if (service == null || !service.isProxiesEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<String> proxyArgs = new ArrayList<String>(4);
        IProxyData httpData = service.getProxyData("HTTP");
        if (httpData != null && httpData.getHost() != null) {
            CollectionsUtil.addToList(proxyArgs, (Object[])new String[]{"--proxy", this.buildProxyURL(httpData, env)});
        }
        if ((httpsData = service.getProxyData("HTTPS")) != null && httpsData.getHost() != null) {
            CollectionsUtil.addToList(proxyArgs, (Object[])new String[]{"--https-proxy", this.buildProxyURL(httpsData, env)});
        }
        return proxyArgs;
    }

    private String buildProxyURL(IProxyData data, Map<String, String> env) {
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        if (!StringUtil.isEmpty((String)data.getUserId())) {
            builder.append(data.getUserId());
            builder.append(':');
            String password = data.getPassword();
            builder.append(password);
            builder.append('@');
            env.put("textToObfuscate", password);
        }
        builder.append(data.getHost());
        if (data.getPort() != -1) {
            builder.append(':');
            builder.append(data.getPort());
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> list(boolean global) throws CoreException {
        String output;
        IStatus status = global ? this.runInBackground("-g", "-p", LIST) : this.runInBackground("-p", LIST);
        if (!status.isOK()) {
            if (status.getCode() != 1 || !(status instanceof ProcessStatus)) throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedListingError, status)));
            ProcessStatus ps = (ProcessStatus)status;
            output = ps.getStdOut();
        } else {
            output = status.getMessage();
        }
        Object[] lines = StringUtil.LINE_SPLITTER.split(output);
        List paths = CollectionsUtil.map((Collection)CollectionsUtil.newSet((Object[])lines), (IMap)new IMap<String, IPath>(){

            public IPath map(String item) {
                return Path.fromOSString((String)item);
            }
        });
        HashSet<String> installed = new HashSet<String>(paths.size());
        for (IPath path : paths) {
            try {
                int count = path.segmentCount();
                if (count < 2 || !"node_modules".equals(path.segment(count - 2))) continue;
                installed.add(path.lastSegment());
            }
            catch (Exception e) {
                if (path.toOSString().contains("npm WARN")) continue;
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", e.getMessage()));
            }
        }
        return installed;
    }

    @Override
    public boolean isInstalled(String packageName) throws CoreException {
        try {
            String version = this.getInstalledVersion(packageName);
            return !StringUtil.isEmpty((String)version);
        }
        catch (CoreException e) {
            IdeLog.logInfo((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Error getting the installed version of package {0}; falling back to use ''npm list''", packageName));
            Set<String> listing = this.list(true);
            return listing.contains(packageName);
        }
    }

    @Override
    public IPath getModulesPath(String packageName, boolean isGlobal, String ... args) throws CoreException {
        List processArgs = CollectionsUtil.newList((Object[])new String[]{"-p", LIST, packageName, SILENT});
        if (isGlobal) {
            CollectionsUtil.addToList((List)processArgs, (Object[])new String[]{"-g"});
        }
        if (args != null) {
            CollectionsUtil.addToList((List)processArgs, (Object[])args);
        }
        IStatus status = this.runInBackground((String[])CollectionsUtil.toArray((List)processArgs));
        IPath moduleIPath = null;
        boolean isPathExists = false;
        String message = status.getMessage();
        if (!StringUtil.isEmpty((String)message)) {
            String[] lines = message.split("\n");
            moduleIPath = Path.fromOSString((String)lines[lines.length - 1]);
            isPathExists = moduleIPath.toFile().exists();
        }
        if (!status.isOK() && !isPathExists) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedListPackageError, packageName)));
        }
        return moduleIPath;
    }

    @Override
    public String getInstalledVersion(String packageName) throws CoreException {
        return this.getInstalledVersion(packageName, true, null);
    }

    @Override
    public String getInstalledVersion(String packageName, boolean global, IPath workingDir) throws CoreException {
        IStatus status;
        String version;
        IPath npmPath = this.checkedNPMPath();
        List args = CollectionsUtil.newList((Object[])new String[]{npmPath.toOSString(), "ls", packageName, SILENT, COLOR, FALSE, JSON, TRUE});
        if (global) {
            args.add("-g");
        }
        if (StringUtil.isEmpty((String)(version = this.getVersion(packageName, (status = this.nodeJS.runInBackground(workingDir, ShellExecutable.getEnvironment(), args)).getMessage())))) {
            return this.readPackageVersion(packageName, workingDir);
        }
        return version;
    }

    private String readPackageVersion(String packageName, IPath workingDir) throws CoreException {
        IPath packageDir;
        if (workingDir == null) {
            workingDir = this.getModulesPath();
        }
        if (!(packageDir = workingDir.append(packageName)).toFile().exists()) {
            packageDir = workingDir.append("node_modules").append(packageName);
        }
        if (packageDir.toFile().exists()) {
            try {
                FileReader reader = new FileReader(packageDir.append("package.json").toFile());
                JSONObject json = (JSONObject)new JSONParser().parse((Reader)reader);
                return (String)json.get((Object)VERSION);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    private String getVersion(String packageName, String output) throws CoreException {
        JSONObject dependencies;
        block5: {
            JSONObject json;
            block4: {
                try {
                    json = (JSONObject)new JSONParser().parse(output);
                    if (json.containsKey((Object)"dependencies")) break block4;
                    return null;
                }
                catch (ParseException e) {
                    IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format(Messages.NodePackageManager_FailedToDetermineInstalledVersion, packageName, e.getMessage()));
                    return null;
                }
            }
            dependencies = (JSONObject)json.get((Object)"dependencies");
            if (dependencies.containsKey((Object)packageName)) break block5;
            return null;
        }
        JSONObject pkg = (JSONObject)dependencies.get((Object)packageName);
        return (String)pkg.get((Object)VERSION);
    }

    @Override
    public String getLatestVersionAvailable(String packageName) throws CoreException {
        IPath npmPath = this.checkedNPMPath();
        Map env = ShellExecutable.getEnvironment();
        List args = CollectionsUtil.newList((Object[])new String[]{npmPath.toOSString(), "view", packageName, VERSION});
        args.addAll(this.proxySettings(env));
        IStatus status = this.nodeJS.runInBackground(null, env, args);
        if (!status.isOK()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedToDetermineLatestVersion, packageName, status.getMessage())));
        }
        String message = status.getMessage().trim();
        Matcher m = VERSION_PATTERN.matcher(message);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public List<String> getAvailableVersions(String packageName) throws CoreException {
        IPath npmPath = this.checkedNPMPath();
        Map env = ShellExecutable.getEnvironment();
        List args = CollectionsUtil.newList((Object[])new String[]{npmPath.toOSString(), "view", packageName, "versions", COLOR, FALSE, JSON, TRUE});
        args.addAll(this.proxySettings(env));
        IStatus status = this.nodeJS.runInBackground(null, env, args);
        if (!status.isOK()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_FailedToDetermineLatestVersion, packageName, status.getMessage())));
        }
        String message = status.getMessage().trim();
        try {
            return (List)new JSONParser().parse(message);
        }
        catch (ParseException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public String getConfigValue(String key) throws CoreException {
        IStatus status = this.runInBackground(CONFIG, GET, key);
        if (!status.isOK()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodePackageManager_ConfigFailure, key, status.getMessage())));
        }
        return status.getMessage().trim();
    }

    private IStatus runNpmInstaller(String packageName, String displayName, boolean global, char[] password, IPath workingDirectory, String command, IProgressMonitor monitor) throws CoreException, IOException, InterruptedException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.NodePackageManager_InstallingTaskName, displayName), (int)100);
        try {
            Bundle bundle;
            IPath pythonExe;
            List<String> args = this.getNpmArguments(global, password);
            if (!PlatformUtil.isWindows() && global) {
                int i = args.indexOf("--");
                args.add(i, "-H");
            }
            CollectionsUtil.addToList(args, (Object[])new String[]{command, packageName, COLOR, FALSE});
            HashMap<String, String> environment = PlatformUtil.isWindows() ? new HashMap<String, String>(System.getenv()) : ShellExecutable.getEnvironment();
            args.addAll(this.proxySettings(environment));
            environment.put("redirectErrorStream", "");
            if (PlatformUtil.isWindows() && (pythonExe = ExecutableUtil.find((String)"pythonw.exe", (boolean)false, null)) == null && (bundle = Platform.getBundle((String)"com.appcelerator.titanium.python.win32")) != null) {
                String pathName = "PATH";
                if (!environment.containsKey(pathName)) {
                    pathName = "Path";
                }
                String path = (String)environment.get(pathName);
                Path relative = new Path(".");
                URL bundleURL = FileLocator.find((Bundle)bundle, (IPath)relative, null);
                URL fileURL = FileLocator.toFileURL((URL)bundleURL);
                File f = new File(fileURL.getPath());
                if (f.exists()) {
                    path = String.valueOf(path) + File.pathSeparator + new File(f, "python").getCanonicalPath();
                    environment.put(pathName, path);
                }
            }
            IStatus iStatus = this.getProcessRunner().run(workingDirectory, environment, password, args, (IProgressMonitor)sub.newChild(100));
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    private List<String> getNpmArguments(boolean global, char[] sudoPassword) throws CoreException {
        IPath npmPath = this.checkedNPMPath();
        ArrayList<String> args = new ArrayList<String>(8);
        if (global) {
            SudoManager sudoMngr = new SudoManager();
            args.addAll(sudoMngr.getArguments(sudoPassword));
            args.add(this.nodeJS.getPath().toOSString());
            args.add(npmPath.toOSString());
            args.add("-g");
        } else {
            args.add(this.nodeJS.getPath().toOSString());
            args.add(npmPath.toOSString());
        }
        return args;
    }

    @Override
    public IStatus uninstall(String packageName, String displayName, boolean global, char[] password, IProgressMonitor monitor) throws CoreException {
        return this.uninstall(packageName, displayName, global, password, null, monitor);
    }

    @Override
    public IStatus uninstall(String packageName, String displayName, boolean global, char[] password, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        try {
            IStatus status = this.runNpmInstaller(packageName, displayName, global, password, workingDirectory, REMOVE, monitor);
            if (status.getSeverity() == 8) {
                return Status.OK_STATUS;
            }
            if (!status.isOK()) {
                String message = status.getMessage();
                String logMsg = MessageFormat.format("Failed to uninstall {0}.\n{1}", packageName, message);
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)logMsg);
                return new Status(4, "com.aptana.js.core", logMsg);
            }
            return status;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IPath getBinariesPath() throws CoreException {
        IPath prefix = this.getConfigPrefixPath();
        if (prefix == null) {
            return null;
        }
        if (PlatformUtil.isWindows()) {
            return prefix;
        }
        return prefix.append(BIN);
    }

    @Override
    public IPath getModulesPath() throws CoreException {
        IPath prefix = this.getConfigPrefixPath();
        if (prefix == null) {
            return null;
        }
        if (PlatformUtil.isWindows()) {
            return prefix.append("node_modules");
        }
        return prefix.append(LIB).append("node_modules");
    }

    @Override
    public synchronized IPath getConfigPrefixPath() throws CoreException {
        if (this.fConfigPrefixPath == null) {
            String npmConfigPrefixPath = (String)ShellExecutable.getEnvironment().get(NPM_CONFIG_PREFIX);
            this.fConfigPrefixPath = npmConfigPrefixPath != null ? Path.fromOSString((String)npmConfigPrefixPath) : Path.fromOSString((String)this.getConfigValue(PREFIX));
        }
        return this.fConfigPrefixPath;
    }

    @Override
    public IStatus cleanNpmCache(char[] password, boolean runWithSudo, IProgressMonitor monitor) {
        List<String> args;
        try {
            args = this.getNpmArguments(runWithSudo, password);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        args.remove("-g");
        CollectionsUtil.addToList(args, (Object[])new String[]{"cache", "clean"});
        String path = PlatformUtil.expandEnvironmentStrings((String)"~");
        IPath userHome = Path.fromOSString((String)path);
        IStatus status = this.getProcessRunner().run(userHome, ShellExecutable.getEnvironment(), password, args, monitor);
        String cacheCleanOutput = status.getMessage();
        if (!status.isOK() || cacheCleanOutput.contains(NPM_ERROR)) {
            return new Status(4, "com.aptana.js.core", cacheCleanOutput);
        }
        return status;
    }

    @Override
    public String getVersion() throws CoreException {
        IStatus status = this.runInBackground("-v");
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        return status.getMessage();
    }

    @Override
    public boolean exists() {
        IPath path = this.getPath();
        if (path == null) {
            return false;
        }
        return path.toFile().isFile();
    }

    @Override
    public synchronized IPath getPath() {
        if (this.npmPath == null) {
            IPath possible;
            IPath nodeParent = this.nodeJS.getPath().removeLastSegments(1);
            this.npmPath = PlatformUtil.isWindows() ? nodeParent.append("node_modules").append(NPM).append(BIN).append("npm-cli.js") : ((possible = nodeParent.append(NPM)).toFile().exists() ? possible : this.findNPMOnPATH(possible));
        }
        return this.npmPath;
    }

    @Override
    public IStatus runInBackground(String ... args) throws CoreException {
        return this.runInBackground((IPath)null, (Map<String, String>)null, args);
    }

    private IStatus runInBackground(IPath workingDir, Map<String, String> environment, String ... args) throws CoreException {
        List newArgs = CollectionsUtil.newList((Object[])args);
        newArgs.add(0, this.checkedNPMPath().toOSString());
        return this.nodeJS.runInBackground(workingDir, environment, newArgs);
    }

    @Override
    public IPath findNpmPackagePath(String executableName, boolean appendExtension, List<IPath> searchLocations, FileFilter filter) {
        return ExecutableUtil.find((String)executableName, (boolean)true, searchLocations, (FileFilter)filter);
    }

    @Override
    public IStatus rebuild(IPath packageDir) throws CoreException {
        return this.runInBackground(packageDir, ShellExecutable.getEnvironment(), REBUILD);
    }
}

